package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.databinding.ObservableBoolean
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class BlockUsersViewModel(
    private val context: Context,
    private val userRepository: UserRepository

) : ViewModel(){

    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences=Functions.getSharedPreference(context)
    }



    var unblockPosition=0
    var noDataLayoutVisibility = ObservableBoolean(false)


    val _blockUserLiveData: MutableLiveData<ApiResponce<String>> = MutableLiveData()
    val blockUserLiveData: LiveData<ApiResponce<String>> get() = _blockUserLiveData

    fun blockUser(userId:String,unblockPosition:Int){
        this.unblockPosition=unblockPosition
        viewModelScope.launch {

            val param = JSONObject()
            if(sharedPreferences.getBoolean(Variables.IS_LOGIN,false)) {
                param.put("block_user_id", userId)
            }
            userRepository.callApiBlockUser(param, _blockUserLiveData)
        }
    }


    val _blockUsersLiveData: MutableLiveData<ApiResponce<ArrayList<UserModel>>> = MutableLiveData()
    val blockUsersLiveData: LiveData<ApiResponce<ArrayList<UserModel>>> get() = _blockUsersLiveData
    fun getblockUsersList(){
        viewModelScope.launch {
            val param = JSONObject()
            userRepository.getBlockUserList(param, _blockUsersLiveData)
        }
    }



    fun showNoDataView(){
        noDataLayoutVisibility.set(true)

    }

    fun showDataView(){
        noDataLayoutVisibility.set(false)
    }





}

class BlockUserFactory(
    private val context: Context,
    private val userRepository: UserRepository
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(BlockUsersViewModel::class.java)) {
            return BlockUsersViewModel(context,userRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}